@extends('template.content')
@section('content')

<div class="mb-3">
    <nav class="navbar navbar-example navbar-expand-lg navbar-light bg-light">
        <div class="container-fluid" style="justify-content: start">
          <a class="btn btn-primary btn-sm" href="{{url('admin/content/create')}}"><i class='bx bx-plus'></i>&nbsp;add data</a>
          </div>
      </nav>
    </div>
  
      <div class="row">
  
          <div class="col-sm-12">
              
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title">{{$title}}</h4>
                      <div class="table-responsive">
                        <table class="table table">
                          <thead>
                            <tr>
                              <th>name</th>
                              <th>wheel</th>
                              <th>outwheel</th>
                              <th>logo</th>
                              <th>background</th>
                              <th>favicon</th>
                              <th>music</th>
                              <th>music_win</th>
                              <th>music_lose</th>
                              <th>music_spin</th>
                              <th>status</th>
                              <th>Action</th>
                            </tr>
                          </thead>
                          <tbody>
                            @foreach($row as $key)
                            <tr>
                              <td>{{$key->name}}</td>
                              <td>
                                  @if($key->wheel)
                                  <a data-fslightbox="gallery" href="{{url('storage/'.$key->wheel)}}">
                                      <img src="{{url('storage/'.$key->wheel)}}" class="img-table" alt="{{$key->name}}">
                                  </a>
                                  @else
                                      <p>no wheel</p>
                                  @endif
                              </td>

                              <td>
                                @if($key->outwheel)
                                <a data-fslightbox="gallery" href="{{url('storage/'.$key->outwheel)}}">
                                    <img src="{{url('storage/'.$key->outwheel)}}" class="img-table" alt="{{$key->name}}">
                                </a>
                                @else
                                    <p>no outwheel</p>
                                @endif
                            </td>

                            <td>
                                @if($key->logo)
                                <a data-fslightbox="gallery" href="{{url('storage/'.$key->logo)}}">
                                    <img src="{{url('storage/'.$key->logo)}}" class="img-table" alt="{{$key->name}}">
                                </a>
                                @else
                                    <p>no logo</p>
                                @endif
                            </td>

                            <td>
                                @if($key->background)
                                <a data-fslightbox="gallery" href="{{url('storage/'.$key->background)}}">
                                    <img src="{{url('storage/'.$key->background)}}" class="img-table" alt="{{$key->name}}">
                                </a>
                                @else
                                    <p>no background</p>
                                @endif
                            </td>
                            <td>
                                @if($key->favicon)
                                <a data-fslightbox="gallery" href="{{url('storage/'.$key->favicon)}}">
                                    <img src="{{url('storage/'.$key->favicon)}}" class="img-table" alt="{{$key->name}}">
                                </a>
                                @else
                                    <p>no favicon</p>
                                @endif
                            </td>

                            <td><a href="{{url('storage/'.$key->music)}}" download="">{{url('storage/'.$key->music)}}</a></td>

                            <td><a href="{{url('storage/'.$key->music_win)}}" download="">{{url('storage/'.$key->music_win)}}</a></td>
                            <td><a href="{{url('storage/'.$key->music_lose)}}" download="">{{url('storage/'.$key->music_lose)}}</a></td>
                            <td><a href="{{url('storage/'.$key->music_spin)}}" download="">{{url('storage/'.$key->music_spin)}}</a></td>

                            <td>{{$key->status}}</td>

                              <td>
                                <a href="{{url('admin/content/edit/'.$key->id)}}" class="btn btn-sm btn-warning">edit</a>
                                <a href="javascript:void(0)" onclick="hapus('{{url('admin/content/destroy/'.$key->id)}}')" class="btn btn-sm btn-danger">delete</a>
                              </td>
                            </tr>
                            @endforeach
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
  
          </div>
      </div>
  
      @push('js')
      <script>
        $(document).ready( function () {
          $('#tabel').DataTable({
            "pageLength": 25,
               searching: true,
               ordering:  true,
               paging: true,   
               "order": [[1, 'desc']],
               "columnDefs": [
                  { "type": "date", "targets": [1] }//date column formatted like "03/23/2018 10:25:13 AM".
                ],     
          });
      });
      </script>
  @endpush
  
  @endsection