@extends('template.content')
@section('content')

<div class="row">
  <div class="col-sm-12">
          <div class="card">
            <div class="card-body">
              <h4 class="card-title">INFORMASI</h4>
              <ul>
                <li>ukuran image hadiah harus 130 x 180 px</li>
                <li>silahkan resize online di <a href="https://www.iloveimg.com/">https://www.iloveimg.com/</a></li>
                <li>silahkan download contoh di sisni <a href="{{url('web/assets/default/image.zip')}}" download> klik di sini</a></li>
                <li>atau lihat contoh assets di folder public/default dan di public/web/assets/defult</li>
                <li>PASTIKAN HARUS ADA LOSE HADIAH JIKA SET DRAW MENGGUNAKAN PRESENTASE</li>
              </ul>
            </div>
          </div>
  </div>
</div>

<div class="mb-3">
  <nav class="navbar navbar-example navbar-expand-lg navbar-light bg-light">
      <div class="container-fluid" style="justify-content: start">
        <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#create">
            <i class='bx bx-plus'></i>
            &nbsp;add data
        </button>
        </div>
    </nav>
  </div>

    <div class="row">
        <div class="col-sm-12">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title">{{$title}}</h4>
                    <div class="table-responsive">
                      <table class="table">
                        <thead>
                          <tr>
                            <th>label</th>
                            <th>sorter</th>
                            <th>presentase</th>
                            <th>prize</th>
                            <th>status</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody>
                          @foreach($row as $key)
                          <tr>
                            <td>{{$key->label}}</td>
                            <td>{{$key->sorter}}</td>
                            <td>{{$key->presentase}}</td>
                            <td>
                              @if($key->file)
                              <a data-fslightbox="gallery" href="{{url('storage/'.$key->file)}}">
                                  <img src="{{url('storage/'.$key->file)}}" class="img-table" alt="{{$key->name}}">
                              </a>
                              @else
                                  <p>no file</p>
                              @endif
                          </td>
                            <td>@php echo Fibonanci::status($key->status); @endphp</td>
                            <td>
                                <button type="button" class="btn btn-warning btn-sm" 
                                data-bs-toggle="modal" data-bs-target="#edit{{$key->id}}">
                                    edit
                                </button>
                                <a href="javascript:void(0)" onclick="hapus('{{url('admin/prize/destroy/'.$key->id)}}')" class="btn btn-sm btn-danger">delete</a>
                            </td>
                          </tr>

                          <div class="modal fade" id="edit{{$key->id}}" tabindex="-1" aria-labelledby="create" aria-hidden="true">
                            <div class="modal-dialog">
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h1 class="modal-title fs-5" id="exampleModalLabel">Modal title</h1>
                                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                        
                                <form action="{{url('admin/prize/update')}}" method="POST" enctype="multipart/form-data">
                                    @csrf

                                    <input type="hidden" value="{{$key->id}}" name="id">
                        
                                <div class="modal-body">

                                    <div class="form-group">
                                        <label for="label">label</label>
                                        <input type="text" value="{{$key->label}}" name="label" class="form-control" id="label" placeholder="label">
                                      </div>
                        
                                      <div class="form-group">
                                        <label for="sorter">sorter</label>
                                        <input type="number" value="{{$key->sorter}}" name="sorter" class="form-control" id="sorter" placeholder="sorter">
                                      </div>
                        
                                      <div class="form-group">
                                        <label for="presentese">presentese</label>
                                        <input type="number" name="presentase" value="{{$key->presentase}}" class="form-control" id="presentese" placeholder="presentese pastikan total 100 dari semua data">
                                      </div>

                                      @if($key->file)
                                      <div class="form-group">
                                        <img src="{{url('storage/'.$key->file)}}" width="200px" alt="">
                                      </div>
                                      @endif

                                      <div class="form-group">
                                        <label for="file">file</label>
                                        <input type="file" name="file" class="form-control" id="file" placeholder="file">
                                      </div>
                        
                                      <div class="mb-3">
                                        <label for="users" class="form-label">status</label>
                                        <select class="form-select" name="status" aria-label="Default select example">
                                          <option value="{{$key->status}}" selected>{{$key->status}}</option>
                                          <option value="win">win</option>
                                          <option value="lose">lose</option>
                                        </select>
                                      </div>
                                    
                                </div>

                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                  <button type="submit" class="btn btn-primary">Update changes</button>
                                </div>
                        
                                </form>
                        
                        
                              </div>
                            </div>
                          </div>

                            @php
                                $n += $key->presentase;
                            @endphp
                          @endforeach
                        </tbody>
                        <thead>
                            <tr>
                              <th>label</th>
                              <th>sorter</th>
                              <th>{{$n}} % </th>
                              <th>status</th>
                              <th>Action</th>
                            </tr>
                          </thead>
                      </table>
                    </div>
                  </div>
                </div>
        </div>
    </div>


    <!-- Modal -->
<div class="modal fade" id="create" tabindex="-1" aria-labelledby="create" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h1 class="modal-title fs-5" id="exampleModalLabel">Modal title</h1>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <form action="{{url('admin/prize/store')}}" method="POST" enctype="multipart/form-data">
            @csrf

        <div class="modal-body">

            <div class="form-group">
                <label for="label">label</label>
                <input type="text" name="label" class="form-control" id="label" placeholder="label">
              </div>

              <div class="form-group">
                <label for="sorter">sorter</label>
                <input type="number" name="sorter" class="form-control" id="sorter" placeholder="sorter">
              </div>

              <div class="form-group">
                <label for="presentese">presentase</label>
                <input type="number" name="presentase" class="form-control" id="presentese" placeholder="presentese pastikan total 100 dari semua data">
              </div>

              <div class="form-group">
                <label for="file">file</label>
                <input type="file" name="file" class="form-control" id="file" placeholder="file">
              </div>

              <div class="mb-3">
                <label for="users" class="form-label">status</label>
                <select class="form-select" name="status" aria-label="Default select example">
                  <option value="win">win</option>
                  <option value="lose">lose</option>
                </select>
              </div>
           

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Save changes</button>
        </div>

        </form>


      </div>
    </div>
  </div>

@push('js')
    <script>
      $(document).ready( function () {
        $('#tabel').DataTable({
          "pageLength": 25,
             searching: true,
             ordering:  true,
             paging: true,   
             "order": [[1, 'desc']],
             "columnDefs": [
                { "type": "date", "targets": [1] }//date column formatted like "03/23/2018 10:25:13 AM".
              ],     
        });
    });
    </script>
@endpush

@endsection