
<?php $__env->startSection('content'); ?>


  <div class="row justify-content-md-center">
    <div class="col-md-6 col-sm-12 grid-margin stretch-card">
      <div class="card" style="max-height:300px">
        <div class="card-body">
          <h4 class="card-title">Create Code / <?php echo e($title); ?></h4>
          <form class="forms-sample" method="POST" action="<?php echo e(url('admin/voucher/store')); ?>">
            <?php echo csrf_field(); ?>
            <div class="form-group">
            </div>
            <button type="submit" class="btn btn-sm btn-primary me-2">Create Code</button>
          </form>
        </div>
      </div>
    </div>
  </div>

    <div class="row">
        <div class="col-sm-12">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title"><?php echo e($title); ?></h4>
                    <div class="table-responsive">
                      <table class="table" id="tabel">
                        <thead>
                          <tr>
                            <th>voucher</th>
                            <th>status</th>
                            <th>tanggal kupon dibuat</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td><?php echo e($key->voucher); ?></td>
                          
                            <td><?php echo Fibonanci::status($key->status); ?></td>
                            <td><?php echo e($key->created_at); ?></td>
                            <td>
                                <button type="button" class="btn btn-warning btn-rounded btn-icon" 
                                data-bs-toggle="modal" data-bs-target="#edit<?php echo e($key->id); ?>">
                                    edit
                                </button>
                                <a href="javascript:void(0)" onclick="hapus('<?php echo e(url('admin/voucher/destroy/'.$key->id)); ?>')" class="btn btn-sm btn-danger">delete</a>
                            </td>
                          </tr>

                          <div class="modal fade" id="edit<?php echo e($key->id); ?>" tabindex="-1" aria-labelledby="create" aria-hidden="true">
                            <div class="modal-dialog">
                              <div class="modal-content">
                                <div class="modal-header">
                                  <h1 class="modal-title fs-5" id="exampleModalLabel">Modal title</h1>
                                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                        
                                <form action="<?php echo e(url('admin/voucher/update')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>

                                    <input type="hidden" value="<?php echo e($key->id); ?>" name="id">
                        
                                <div class="modal-body">

                                  <div class="form-group">
                                    <label for="voucher">voucher</label>
                                    <input type="text" class="form-control" id="voucher" value="<?php echo e($key->voucher); ?>" name="voucher" placeholder="voucher">
                                  </div>

                                  <div class="mb-3">
                                    <label for="users" class="form-label">status</label>
                                    <select class="form-select" name="status" aria-label="Default select example">
                                      <option value="<?php echo e($key->status); ?>" selected><?php echo e($key->status); ?></option>
                                      <option value="used">used</option>
                                      <option value="not used">not used</option>
                                    </select>
                                  </div>
                                </div>
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                  <button type="submit" class="btn btn-primary">Update changes</button>
                                </div>
                        
                                </form>
                        
                        
                              </div>
                            </div>
                          </div>


                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
        </div>
    </div>


<form class="forms-sample" id="confirm" method="POST" action="<?php echo e(url('admin/voucher/save')); ?>">
            <?php echo csrf_field(); ?>

            <input type="hidden" name="member_id" id="member_id" value="<?php echo e(session('username')); ?>">

</form>

<?php $__env->startPush('js'); ?>
    <script>
      $(document).ready( function () {
        $('#tabel').DataTable({
          "pageLength": 25,
             searching: true,
             ordering:  true,
             paging: true,   
             "order": [[1, 'desc']],
             "columnDefs": [
                { "type": "date", "targets": [1] }//date column formatted like "03/23/2018 10:25:13 AM".
              ],     
        });
    });
    </script>

    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
        });
    </script>

<?php if(session()->has('confirm')): ?>
    <script>
        Swal.fire({
        title: "<?php echo e(session('confirm')); ?>",
        text: "<?php echo e(session('content')); ?>",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, buatkan kupon!'
      }).then((result) => {
        if (result.isConfirmed) {
          $( "#confirm" ).submit();
          Swal.fire(
            'Confirm!',
            'done create kupon.',
            'success'
          )
        }
      })
    </script>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SPIN\SPIN-IMAGE\resources\views/admin/management/voucher/index.blade.php ENDPATH**/ ?>