<?php

namespace App\Http\Controllers\Wheel;

use App\Http\Controllers\Controller;
#PACKAGE
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Ixudra\Curl\Facades\Curl;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\File;
use Carbon\Carbon;
use Hash;
#HELPER
use Cron;
use Date;
use Fibonanci;
use Helper;
use Nfs;
use Payments;
use Wa;
#MODEL
use App\Models\User;
use App\Models\Cms\Role;

#WHEEL
use App\Models\Wheel\SpinContent;
use App\Models\Wheel\SpinDraw;
use App\Models\Wheel\SpinFaq;
use App\Models\Wheel\SpinHistory;
use App\Models\Wheel\SpinPrize;
use App\Models\Wheel\SpinVoucher;


class ContentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public static function init(){
        $data['link']='content';

        return $data;
    }

    public function index()
    {
        $data                   = Self::init();
        $data['title']          = 'content';
        $data['row']            = SpinContent::listData();

        return view('admin.management.content.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data                   = Self::init();
        $data['title']          = 'create content';
        $data['subtitle']       = 'this is the management  content menu';
        return view('admin.management.content.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'        => 'required',
            'status'      => 'required',
            'logo'        => 'required|file|image',
            'wheel'       => 'required|file|image',
            'outwheel'    => 'required|file|image',
            'background'  => 'required|file|image',
            'favicon'     => 'required|file|mimes:jpg,bmp,png,jpeg,ico',
            'music'       => 'required|file',
            'music_win'   => 'required|file',
            'music_lose'  => 'required|file',
            'music_spin'  => 'required|file',
        ]);

        $save = SpinContent::insertData($request);

        if($save){
            return redirect()->back()->with('message','success save data')->with('message_type','primary');
        }else{
            return redirect()->back()->with('message','failed save data')->with('message_type','warning');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data            = Self::init();
        $data['title']   = 'show content';
        $data['subtitle']= 'this is the management content menu';
        $data['row']     = SpinContent::find($id);
        return view('admin.management.content.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data            = Self::init();
        $data['title']   = 'Edit content';
        $data['subtitle']= 'this is the management content menu';
        $data['row']     = SpinContent::find($id);
        return view('admin.management.content.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $request->validate([
            'name'        => 'required',
            'status'      => 'required',
            'id'          => 'required',
        ]);

        $save = SpinContent::updateData($request);

        if($save){
            return redirect()->back()->with('message','success update data')->with('message_type','primary');
        }else{
            return redirect()->back()->with('message','failed update data')->with('message_type','warning');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
