<?php

namespace App\Models\Wheel;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Helper;
use Illuminate\Support\Facades\Storage;

class SpinPrize extends Model
{
    use HasFactory;
    protected $table = 'spin_prize';

    protected $fillable = [
        'id',
        'label',
        'status',
        'file',
        'presentase',
        'sorter',
        'created_at',
        'updated_at'
    ];

    public function getIncrementing()
    {
        return false;
    }

    /**
     * Get the auto-incrementing key type.
     *
     * @return string
     */
    public function getKeyType()
    {
        return 'string';
    }

    public static function listData(){
        $data = SpinPrize::orderBy('sorter','asc')->get();

        return $data;
    }

    public static function insertData($request){

        if($request->file('file')){

            $file=Helper::image($request->file('file'),'prize');
        }

        $data = SpinPrize::create([
            'id' => (string) Str::uuid(),
            'label' => $request->label,
            'file' => $file,
            'presentase' => $request->presentase,
            'status' => $request->status,
            'sorter' => $request->sorter,
        ]);

        return $data;
    }

    public static function updateData($request){
        $check=SpinPrize::find($request->id);

        if($check->file){
            if($request->file('file')){
                Storage::delete('public/'.$check->file);

                $file=Helper::image($request->file('file'),'prize');
            }else{
                $file=$check->file;
            }
        }else{
            if($request->file('file')){

                $file=Helper::image($request->file('file'),'prize');
            }else{
                $file=$check->file;
            }
        }

        $data = SpinPrize::where('id',$request->id)->update([
            'label' => $request->label,
            'presentase' => $request->presentase,
            'file' => $file,
            'status' => $request->status,
            'sorter' => $request->sorter,
        ]);

        return $data;
    }

    public static function detailData($id){
        $data = SpinPrize::where('id',$id)->first();

        return $data;
    }
}
