<!doctype html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <title><?php echo e(Fibonanci::content()['name']); ?></title>

    <?php echo $__env->make('web.tema.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  
    <style>
        body {
        background: url("<?php echo e(Fibonanci::content()['background']); ?>") no-repeat center center fixed;
        -webkit-background-size: cover;
        -moz-background-size: cover;
        background-size: cover;
        -o-background-size: cover;
        }

        div.the_wheel
        {
            background-image: url("<?php echo e(Fibonanci::content()['outwheel']); ?>");
            background-size: 560px;
            background-repeat: no-repeat;
            background-position: center center;
            padding-left: 0px;
            padding-right: 0px;
            margin-left: 0px;
            margin-right: 0px;
        }

        @media (max-width: 748px) {
        .width-form {
            width: 100%;
          }
          .logo-mobile{
            display: block
          }
          .logo-pc{
            display: none
          }
          .tabel-pc{
            display: none
          }
          .tabel-mobile{
            display: block;
          }
        }

        @media (min-width: 749px) {
          .width-form {
            width: 50%;
          }
          .logo-mobile{
            display: none
          }
          .logo-pc{
            display: block
          }
          .tabel-pc{
            display: block
          }
          .tabel-mobile{
            display: none;
          }
        }

        .myButton {
          box-shadow: 0px 10px 14px -7px #3e7327;
          background:linear-gradient(to bottom, #77b55a 5%, #72b352 100%);
          background-color:#77b55a;
          border-radius:8px;
          display:inline-block;
          cursor:pointer;
          color:#ffffff;
          font-family:Arial;
          font-size:20px;
          font-weight:bold;
          padding:13px 32px;
          text-decoration:none;
          text-shadow:0px 1px 0px #3d6b1e;
        }
        .myButton:hover {
          background:linear-gradient(to bottom, #72b352 5%, #77b55a 100%);
          background-color:#72b352;
        }
        .myButton:active {
          position:relative;
          top:1px;
        }

    </style>

    <?php echo $__env->yieldPushContent('css'); ?>

    <link rel="stylesheet" href="<?php echo e(url('web/assets/sweetalert2/sweetalert2.css')); ?>">

</head>
  <body>

    <div class="container mt-20">
      <div class="row">
          <div class="col-sm-12">
        <?php if(session()->has('message')): ?>

              <?php $__env->startPush('js'); ?>
              <script>
                Swal.fire({
                  position: 'center',
                  icon: 'error',
                  title: "<?php echo e(session('message')); ?>",
                  showConfirmButton: false,
                  timer: 3000
                })
              </script>
          <?php $__env->stopPush(); ?>

        <?php else: ?>

            <?php if($spin=="false"): ?>

                  <?php $__env->startPush('js'); ?>
                      <script>
                            let music_home = document.getElementById("my_audio"); 
                            document.addEventListener("DOMContentLoaded", function(){
                              $(".swal2-modal").css('background-color', '#000');
                              Swal.fire({
                                    title: '<?php echo e(str_replace(array("\r", "\n"), '', Nfs::content("welcome")["title"])); ?>',
                                    html: '<p><?php echo e(str_replace(array("\r", "\n"), '', Nfs::content("welcome")["description"])); ?></p>',
                                    confirmButtonText:
                                    '<i class="fa fa-like"></i>Thank You',
                                    confirmButtonColor: 'goldenrod',
                                  }).then((result) => {
                              /* Read more about isConfirmed, isDenied below */
                              if (result.isConfirmed) {
                                  music_home.play(); 
                                }})
                            });
                      </script>                  
                  <?php $__env->stopPush(); ?>

              <?php endif; ?>

        <?php endif; ?>
          </div>
      </div>
    </div>


    <?php echo $__env->yieldContent('content'); ?>


    <?php echo $__env->make('web.tema.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    <script>

      var app = <?php echo e(Js::from($prize)); ?>;

      let hadiah = [];
      app.forEach(function (item, index) {

        arr = {
          "image" : '<?php echo e(url("storage")); ?>/'+item.file,
          "text"  : item.label
        }
        hadiah.push(arr)

      });
      

    </script>

  <?php echo $__env->yieldPushContent('js'); ?>

   
  </body>
</html><?php /**PATH /home/yamaha/public_html/ayam.yamahabismamandiri.com/resources/views/web/tema/content.blade.php ENDPATH**/ ?>