<?php

namespace App\Http\Controllers\Wheel;

use App\Http\Controllers\Controller;
#PACKAGE
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Ixudra\Curl\Facades\Curl;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Validator;
use Hash;
#HELPER
use Cron;
use Date;
use Fibonanci;
use Helper;
use Nfs;
use Payments;
use Wa;
#MODEL
use App\Models\User;
use App\Models\Cms\Role;

#WHEEL
use App\Models\Wheel\SpinContent;
use App\Models\Wheel\SpinDraw;
use App\Models\Wheel\SpinFaq;
use App\Models\Wheel\SpinHistory;
use App\Models\Wheel\SpinPrize;
use App\Models\Wheel\SpinVoucher;

class DrawController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public static function init(){
        $data['link']='draw';

        return $data;
    }

    public function index()
    {
        $data                   = Self::init();
        $data['title']          = 'draw / tickets';
        $data['row']            = SpinDraw::listData();

        return view('admin.management.draw.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data                   = Self::init();
        $data['title']          = 'create tickets';
        $data['subtitle']       = 'this is the management  tickets menu';
        $data['voucher']        = SpinVoucher::listDataNotUsed();
        $data['prize']          = SpinPrize::listData();
        return view('admin.management.draw.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'voucher_id'        => 'required',
            'expired_date'      => 'required',
            'type'              => 'required',
        ]);

        $check = SpinDraw::where('voucher_id',$request->voucher_id)->first();

        if($check){
            return redirect()->back()->with('message','kupon yang sama sudah dibuatkan ticket, harap pilih kupon lain !!')->with('message_type','danger');
        }else{
            $save = SpinDraw::insertData($request);
        }

        if($save){
            return redirect()->back()->with('message','success save data')->with('message_type','primary');
        }else{
            return redirect()->back()->with('message','failed save data')->with('message_type','warning');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id                     = Nfs::Decrypt($id);

        $data                   = Self::init();
        $data['title']          = 'edit tickets';
        $data['subtitle']       = 'this is the management  tickets menu';
        $data['voucher']        = SpinVoucher::listDataNotUsed();
        $data['prize']          = SpinPrize::listData();
        $data['row']            = SpinDraw::detailData($id);
        return view('admin.management.draw.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $request->validate([
            'voucher_id'        => 'required',
            'expired_date'      => 'required',
            'type'              => 'required',
            'status'            => 'required',
            'id'                => 'required',
        ]);

        $save = SpinDraw::updateData($request);

        if($save){
            return redirect()->back()->with('message','success update data')->with('message_type','primary');
        }else{
            return redirect()->back()->with('message','failed update data')->with('message_type','warning');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = SpinDraw::where('id',$id)->delete();

        if($delete){
            return redirect()->back()->with('message','success delete data')->with('message_type','primary');
        }else{
            return redirect()->back()->with('message','failed delete data')->with('message_type','warning');
        }
    }
}
