<?php

namespace App\Models\Wheel;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class SpinFaq extends Model
{
    use HasFactory;
    protected $table = 'spin_faq';

    protected $fillable = [
        'id',
        'content',
    ];

    public function getIncrementing()
    {
        return false;
    }

    /**
     * Get the auto-incrementing key type.
     *
     * @return string
     */
    public function getKeyType()
    {
        return 'string';
    }

    public static function listData(){
        $data = SpinFaq::orderBy('created_at','desc')->get();

        return $data;
    }

    public static function insertData($request){
        $data = SpinFaq::create([
            'id' => (string) Str::uuid(),
            'content' => $request->content
        ]);

        return $data;
    }

    public static function updateData($request){
        $data = SpinFaq::where('id',$request->id)->update([
            'content' => $request->content
        ]);

        return $data;
    }

    public static function detailData($id){
        $data = SpinFaq::where('id',$id)->first();

        return $data;
    }
}
