<?php

namespace App\Models\Wheel;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
class SpinHistory extends Model
{
    use HasFactory;
    protected $table = 'spin_history';

    protected $fillable = [
        'id',
        'draw_id',
        'prize_id',
        'date',
    ];

    public function getIncrementing()
    {
        return false;
    }

    /**
     * Get the auto-incrementing key type.
     *
     * @return string
     */
    public function getKeyType()
    {
        return 'string';
    }

    public static function listData(){
        $data = SpinHistory::leftJoin('spin_draw','spin_history.draw_id','=','spin_draw.id')
                ->leftJoin('spin_prize','spin_history.prize_id','=','spin_prize.id')
                ->leftJoin('spin_voucher','spin_draw.voucher_id','=','spin_voucher.id')
                ->select('spin_history.*','spin_prize.label as prize','spin_voucher.voucher','spin_draw.type')
                ->orderBy('spin_history.created_at','desc')
                ->get();


        return $data;
    }

    public static function listDataToDay(){
        $data = SpinHistory::leftJoin('spin_draw','spin_history.draw_id','=','spin_draw.id')
                ->leftJoin('spin_prize','spin_history.prize_id','=','spin_prize.id')
                ->leftJoin('spin_voucher','spin_draw.voucher_id','=','spin_voucher.id')
                ->whereDate('spin_history.date',date('Y-m-d'))
                ->select('spin_history.*','spin_prize.label as prize','spin_voucher.voucher','spin_draw.type')
                ->orderBy('spin_history.created_at','desc')
                ->get();


        return $data;
    }
}
