<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSpinDrawTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('spin_draw', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('voucher_id')->nullable();
            $table->string('prize_id')->nullable();
            $table->string('type')->nullable();
            $table->string('status')->nullable();
            $table->date('expired_date');
            $table->integer('rotation')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('spin_draw');
    }
}
